rm(list=ls())
source("MaximumEntropyEI.R")
source("simulate.R")

execOne <- function(n,I,J,K,observe=c(i=1,j=1,k=1)){
        lambda <- rgamma(I*J*K,shape=1,scale=1)
        p.ijk <- lambda/sum(lambda)
        x.ijk <- rmultinom(n=1,size=n,prob=p.ijk)
        dim(p.ijk) <- c(I,J,K)
        dim(x.ijk)  <- c(I,J,K)
        n.ij <- apply(x.ijk,c(1,2),sum)
        n.ik <- apply(x.ijk,c(1,3),sum)
        n.jk <- apply(x.ijk,c(2,3),sum)
        n.k <- apply(x.ijk,3,sum)
        f.ijk <- x.ijk/n
        phat.ijk <- MaxEntMultinomial3(
                            n.ij=n.ij,
                            n.ik=n.ik,
                            n.jk=n.jk,
                            sample=n.ij,
                            trace=FALSE
                            )
        theta <- DirichletParms(phat.ijk)
        plimits <- DirichletToBetaItv(theta)
        if(n<1e6) method <- 1 else method <- 2
        limits <- DirichletToBetaBinomItv(theta,n=n,method=method)
        count.coverage <- limits$lower < x.ijk & x.ijk < limits$upper
        prob.coverage <- plimits$lower < p.ijk & p.ijk < plimits$upper
        lower.mbased <- qbinom(p=0.025,prob=phat.ijk,size=n)
        upper.mbased <- qbinom(p=0.975,prob=phat.ijk,size=n)
        mbased.count.coverage <- lower.mbased < x.ijk & x.ijk < upper.mbased
        observe <- as.matrix(t(observe))
        result <- c(
            size=I*J*K,
            theta0=sum(theta),
            count=x.ijk[observe],
            unit.sum=n.k[observe[,"k"]],
            prob=p.ijk[observe],
            prediction = phat.ijk[observe],
            p.lower=plimits$lower[observe],
            p.upper=plimits$upper[observe],
            lower=limits$lower[observe],
            upper=limits$upper[observe],
            lower.mbased = lower.mbased[observe],
            upper.mbased = upper.mbased[observe],
            count.inside = count.coverage[observe],
            prob.inside = prob.coverage[observe],
            cover.count = mean(count.coverage),
            cover.prob = mean(prob.coverage),
            count.inside.mbased = mbased.count.coverage[observe],
            cover.count.mbased = mean(mbased.count.coverage)
        )
        print(result[c("count","lower.mbased","upper.mbased","cover.count","cover.count.mbased")])
        #print(result)
        return(result)
}

conditions <- data.frame(
    I = c(3,3,3,3,7,7,7,7),
    J = c(3,3,3,3,7,7,7,7),
    K = c(50,50,200,200,50,50,200,200),
    n = c(1e5,1e7,1e5,1e7,1e5,1e7,1e5,1e7)
    )


(t0 <- Sys.time())
results.long <- simulate(execOne,conditions=conditions,replications=2000)
(t1 <- Sys.time())
print(t1-t0)

filename.longrun.dated <- paste("bb-simulation-longrun-",format(Sys.time(),"%A-%d-%B-%Y-%X"),".Rdata",sep="")
filename.longrun.default <- "bb-simulation-newest.Rdata"

save(results.long,file=filename.longrun.dated)
file.remove(filename.longrun.default)
file.symlink(filename.longrun.dated,filename.longrun.default)
