simulate <- function(
    FUN=Normal.example,
    replications=10,
    conditions=data.frame(
            mean=c(0,0,1,1),
            sd=c(1,10,1,10),
            n=10
            ),
    names=NULL,
    ...
    ){
    conditions <- as.data.frame(conditions)
    results <- vector(mode="list",length=nrow(conditions))
    for(i in 1:nrow(conditions)){
            cat("\n---------------------------------------------------\n")
            print(conditions[i,])
            myfun <- function(repl){
              cat("Replication",repl,"\n")
              do.call(FUN,conditions[i,])
            }
            results[[i]] <- data.frame(t(sapply(1:replications,myfun)))
        }
    results <- do.call("rbind",results)
    if(!missing(names)) names(result) <- names
    ii <- rep(1:nrow(conditions),rep(replications,nrow(conditions)))
    conditions <- conditions[ii,]
    cbind(conditions,results)
}

Normal.example <- function(mean=0,sd=1,n=10,...){
    x <- rnorm(n=n,mean=mean,sd=sd)
    c(
      mean=mean(x),
      median=median(x),
      var=var(x)
    )
}

# simulate()