makeTable <- function (formula,
                        data = parent.frame(),
                        subset,
                        na.action,
                        exclude = c(NA, NaN),
                        drop.unused.levels = FALSE,
                        rename=NULL)
{
    if (any(attr(terms(formula, data = data), "order") > 1))
        stop("interactions are not allowed")
    m <- match.call(expand.dots = FALSE)
    fcall <- formula[[2]]
    formula <- formula[-2]
    names(m)[2] <- "formula"
    m$formula <- formula
    if (is.matrix(eval(m$data, parent.frame())))
        m$data <- as.data.frame(data)
    m$... <- m$exclude <- m$drop.unused.levels <- m$rename <- NULL
    m[[1]] <- as.name("model.frame")
    by <- eval(m, parent.frame())
    by <- lapply(by, function(u) {
        if (!is.factor(u))
            u <- factor(u, exclude = exclude)
        u[, drop = drop.unused.levels]
    })

    dims <- sapply(by,nlevels)
    dimnam <- lapply(by,levels)
    names(dimnam) <- names(by)
    
    res <- sapply(split(as.data.frame(data),by),function(x)eval(fcall,x))
    if(!is.array(res)){
      dim(res) <- dims
      dimnames(res) <- dimnam
      resp.names <- deparse(fcall)
    }
    else {
      if(length(dimnames(res)[[1]]))
        resp.names <- dimnames(res)[1]
      else{
        resp.names <- list(sapply(fcall,deparse)[-1])
      }
      if(dim(res)[1]!=length(fcall)-1)
       stop("Invalid left hand side in formula")
      dim(res) <- c(dim(res)[1],dims)
      dimnames(res) <- c(resp.names,dimnam)
      resp.names <- unlist(resp.names)
    }
    if(!missing(rename))
      dimnames(res) <- rename(dimnames(res),rename)
    structure(res,
      class=c("Table","table"),
      call=match.call(),
      resp.names=resp.names)
}
