rm(list=ls())
source("LaTeX.R")
source("makeTable.R")

load("simulation-newest.Rdata")

results <- transform(results,
    array.ext = cases(
        "$3\\times 3\\times 50 $"=(I==3 & K==50),
        "$7\\times 7\\times 50 $"=(I==7 & K==50),
        "$3\\times 3\\times 200$"=(I==3 & K==200),
        "$7\\times 7\\times 200$"=(I==7 & K==200)
        ),
    popsiz=as.factor(format(n,big.mark=","))
    )


count.coverage <- makeTable(mean(count.inside)~array.ext+popsiz,
                                      data=results.long,
                                      rename=c(
                                        array.ext="Array size",
                                        popsiz="Population size")
                                      )


count.coverage.mbased <- makeTable(mean(count.inside.mbased)~array.ext+popsiz,
                                      data=results,
                                      rename=c(
                                        array.ext="Array size",
                                        popsiz="Population size")
                                      )


##########################


cat(LaTeX(100*count.coverage,digits=1,colspecs="D"),
  file="CountCoverage.tex")

cat(LaTeX(100*count.coverage.mbased,digits=1,colspecs="D"),
  file="CountCoverage-ModelBased.tex")

