rm(list=ls())
options(error=recover)
load("NewZealand.RData")
source("MaximumEntropyEI.R")

TrueProp.Split <- total.split/(total.split+total.straight)

rdirich <- function(n,theta){
    g <- rgamma(n=n*length(theta),theta)
    dim(g) <- c(length(theta),n)
    sweep(g,2,colSums(g),"/")
}

rcompmult <- function(n,size,theta){
    p <- rdirich(n=1,theta=theta)
    rmultinom(n=n,size=size,prob=p)
}


randomSplitTickets <- function(Parms,length,n){
    I <- dim(Parms)[1]
    J <- dim(Parms)[2]
    K <- dim(Parms)[3]
    x.r.ijk <- array(0,dim=c(I,J,K,length))
    tmp <- rcompmult(n=length,theta=Parms[Parms>0],size=n)
    ok <- array(Parms>0,dim=dim(x.r.ijk))
    x.r.ijk[ok] <- tmp
    dim(x.r.ijk) <- c(I,J,K,length)
    iikl <- as.matrix(expand.grid(1:I,1:K,1:length))[,c(1,1,2,3)]
    s.r.k <- x.r.ijk[iikl]
    dim(s.r.k) <- c(I,K,length)
    s.r.k <- apply(s.r.k,2:3,sum)
    n.k <- apply(x.r.ijk,3:4,sum)
    (n.k - s.r.k)/n.k
}

m <- sum(cross.section)
n <- sum(candidate.votes)

replication <- function(r,verbose=FALSE,n.rand=300,trace=FALSE){
    if(verbose)
        cat("\nReplication:",r)
    m.resample <- rmultinom(1,size=m,prob=cross.section/m)
    sample <- rmultinom(1,size=n,prob=m.resample/m)
    dim(sample) <- dim(cross.section)
    sample.result <- MaxEntMultinomial3(
        n.ij=sample,
        n.ik=t(candidate.votes),
        n.jk=t(list.votes),
        #start=NewZealand.Multin,
        sample=n.ij,
        trace=trace,
        maxiter=200
        )
    attr(sample.result,"params") <- NULL
    if(verbose)
      cat(" IPF iterations: ",attr(sample.result,"iterations"))
    sample.parms <- DirichletParms(sample.result)#,theta.0=theta.0)
    if(verbose)
      cat(" theta.0",sum(sample.parms))
    
    randomSplitTickets(sample.parms,length=n.rand,n=attr(sample.result,"n"))
}


get.means <- function(boot.results) apply(boot.results,1,mean)
get.limits <- function(boot.results) t(apply(boot.results,1,quantile,probs=c(.025,.975)))

bootstrap.NewZealand <- function(nrepl=2000,verbose=TRUE,trace=FALSE){
  boot.results <- sapply(1:nrepl,replication,verbose=verbose,trace=trace,n.rand=1)
  if(verbose) cat("\n")
  dim(boot.results) <- c(67,dim(boot.results)[1]/67*dim(boot.results)[2])
  limits <- get.limits(boot.results)
  structure(
    data.frame(
      prediction = get.means(boot.results),
      lower = limits[,1],
      upper = limits[,2]
    ),
    complete = boot.results
  )
}

EstProp.Split <- bootstrap.NewZealand(nrepl=2000)

results.filename.dated <- paste("Bootstrap-NewZealand-",format(Sys.time(),"%A-%d-%B-%Y-%X"),".RData",sep="")
results.filename.default <- "Bootstrap-NewZealand-newest.RData"

save(EstProp.Split,TrueProp.Split,
  file=results.filename.dated
  )

file.remove(results.filename.default)
file.symlink(results.filename.dated,results.filename.default)