rm(list=ls())

load("Bootstrap-NewZealand-FI-newest.RData")


Bootdata <- data.frame(
    TruePerc = 100*TrueProp.Split,
    PredPerc = 100*EstProp.Split$prediction,
    Lower=100*EstProp.Split$lower,
    Upper=100*EstProp.Split$upper
)
attach("NewZealand.RData")

Bootdata <- Bootdata[order(Bootdata$PredPerc),]

Bootdata <- transform(Bootdata,index=1:length(TruePerc))

Plot.bootstrap <- function(){
  opar <- par(mar=c(3, 4, 4, 2) + 0.1)
  par(ask=FALSE)
  plot(TruePerc~index,
      data=Bootdata,
      ylab="Percentage of split tickets",
      #ylim=range(with(Bootdata,range(Lower,Upper))),
      ylim=c(15,95),
      #xlim=with(Bootdata,range(index)),
      xlab="Voting district, sorted by predicted percentage of ticket-splitters",
      axes=FALSE
      )
  #grid()
  axis(2)
  box()
  mtext("Voting district, sorted by predicted percentage of ticket-splitters",side=1,line=1)
  with(Bootdata,(segments(y0=Lower,y1=Upper,
            x0=index,x1=index)))#,
            #lwd=3,
            #col="gray50")))

  points(PredPerc~index,data=Bootdata,pch=21,bg="white")
  points(TruePerc~index,data=Bootdata,pch=15)
  legend("topleft",
    legend=c("Predicted percentages","Actual percentages"),
    pch=c(21,15)
    )
  par(opar)
}
Plot.bootstrap()

par(ask=FALSE)
postscript(file="NewZealand-SplitPerc-Bootstrap-Variant.eps",
            paper="special",
            width=10,
            height=7.55,
            horizontal=FALSE
            )
Plot.bootstrap()
dev.off()
pdf(file="NewZealand-SplitPerc-Bootstrap-Variant.pdf",
            paper="special",
            width=10,
            height=7.55
            )
Plot.bootstrap()
dev.off()
