if(!length(getOption("OutDec"))) options(OutDec=".")

format.args <- function(
  digits=getOption("digits"),
  width=NULL,
  format=NULL,
  flag="-",
  mode=NULL,
  big.mark="",
  big.interval=3,
  small.mark="",
  small.interval=5,
  decimal.mark=getOption("OutDec"),
  ...
  ) {
  args <- list(
    digits=digits,
    width=width,
    format=format,
    flag=flag,
    mode=mode,
    big.mark=big.mark,
    big.interval=big.interval,
    small.mark=small.mark,
    small.interval=small.interval,
    decimal.mark=decimal.mark
  )
  
  generator <- function(...)structure(list(...),class="format.args")
  warnoption <- getOption("warn")
  options(warn=-1)
  res <- do.call("mapply",c(list(FUN=generator),args,list(SIMPLIFY=FALSE)))
  options(warn=warnoption)
  res
}










LaTeX.default <- function(x,
  format.args=NULL,
  colspecs="r",
  header.format="c",
  first.colspec="l",
  format="f",
  hlines=c("booktabs","default","none"),
  ...){
  x <- as.matrix(x)
  have.dimnames <- length(dimnames(x))
  have.dimnameLabels <- if(have.dimnames) length(names(dimnames(x)))
                        else FALSE
  have.only.rownames <- length(rownames(x)) && !length(colnames(x))
  have.only.colnames <- length(colnames(x)) && !length(rownames(x))
  have.rownames <- length(rownames(x)) 
  have.colnames <- length(colnames(x)) 
  have.both <- length(rownames(x)) && length(colnames(x))
  if(missing(format.args)) format.args <- do.call("format.args",list(...,format=format))
  if(inherits(format.args,"format.args"))
    format.args <- rep(list(format.args),ncol(x))
  else {
    if(!all(sapply(format.args,inherits,"format.args"))) stop("Cannot handle these format.args")
    warnoption <- getOption("warn")
    options(warn=-1)
    tmp <- list()
    tmp[1:ncol(x)] <- format.args
    options(warn=warnoption)
    format.args <- tmp
  }
  hlines <- match.arg(hlines)
  
  body <- matrix("",nrow=nrow(x),ncol=ncol(x))
  for(j in 1:ncol(x)){
    x.j <- x[,j]
    body[!is.na(x.j),j] <- do.call("formatC",c(list(x=x.j[!is.na(x.j)]),format.args[[j]]))
  }
  if(have.dimnames){
    if(have.colnames)
      make.headers <- function(x)paste("\\multicolumn{1}{",header.format,"}{",x,"}",sep="")
    if(have.rownames){
      rowNames <- unname(rownames(x))
      body <- cbind(rowNames,body)
    }
    if(have.only.colnames){
      colNames <- unname(sapply(colnames(x),make.headers))
      body <- rbind(colNames,body)
    }
    if(have.both){
      colNames <- unname(c("",sapply(colnames(x),make.headers)))
      body <- rbind(colNames,body)
    }
  }
  collapse.row <- function(x) paste(x,collapse=" & ")
  body <- cbind(body[,1],apply(body[,-1],1,collapse.row))
  if(have.dimnameLabels){
    super.header <- names(dimnames(x))
    super.header[2] <- paste("\\multicolumn{",ncol(x),"}{c}{",super.header[2],"}",sep="")
    body[1,1] <- super.header[1]
    super.header[1] <- ""
    if(nchar(super.header[2])>0)
      body <- rbind(super.header,body)
  }
  body <- apply(body,1,collapse.row)
  body <- paste(body,"\\\\\n")
  if(hlines=="booktabs"){
    body[1] <- paste("\\toprule\n",body[1],sep="")
    body[length(body)] <- paste(body[length(body)],"\\bottomrule\n",sep="")
    if(have.dimnameLabels){
      if(nchar(super.header[2])>0){
        if(have.rownames)
          body[1] <- paste(body[1],"\\cmidrule{",2,"-",ncol(x)+1,"}\n",sep="")
        else
          body[1] <- paste(body[1],"\\cmidrule{",1,"-",ncol(x),"}\n",sep="")
      }
      body[2] <- paste(body[2],"\\midrule\n",sep="")
    }
    else
      body[1] <- paste(body[1],"\\midrule\n",sep="")
  }
  if(hlines=="default"){
    body[1] <- paste("\\hline\n",body[1],sep="")
    body[length(body)] <- paste(body[length(body)],"\\hline\n",sep="")
    if(have.dimnameLabels){
      if(nchar(super.header[2])>0){
        if(have.rownames)
          body[1] <- paste(body[1],"\\cline{",2,"-",ncol(x)+1,"}\n",sep="")
        else
          body[1] <- paste(body[1],"\\cline{",1,"-",ncol(x),"}\n",sep="")
        }
      body[2] <- paste(body[2],"\\hline\n",sep="")
    }
    else
      body[1] <- paste(body[1],"\\hline\n",sep="")
  }
  body <- paste(body,collapse="")

  if(colspecs=="D"){
    colspecs <- paste("D{",
                          sapply(format.args,function(x)x$decimal.mark),
                          "}{",
                          sapply(format.args,function(x)x$decimal.mark),
                          "}{",
                          sapply(format.args,function(x)x$digits),
                          "}",
                          sep="")
  }
  warnoption <- getOption("warn")
  options(warn=-1)
  tmp <- c()
  tmp[1:ncol(x)] <-colspecs
  colspecs <- paste(tmp,collapse="")
  options(warn=warnoption)
  begin.env <- paste("\\begin{tabular}{",
                          if(have.rownames)
                            paste(first.colspec,colspecs,sep="")
                          else colspecs,
                          "}\n",sep="")
                          
  end.env <- "\\end{tabular}\n"
  
  paste(begin.env,body,end.env,sep="")
}

LaTeX <- function(...)UseMethod("LaTeX")


