#include <R.h>
#include <Rmath.h>

double _p_betabinom_exact(
  double x,
  double n,
  double phi,
  double psi){
    int i;
    double p_lower, f_lower, p_lower_1, f_lower_1;
    
    p_lower = exp(
        + lgammafn(psi + n)
        - lgammafn(phi+psi+n)
        - lgammafn(psi)
        + lgammafn(phi+psi)
                 );

    if(x==0) return(p_lower);

    f_lower = n/(n-1+psi)*exp(lgammafn(1+phi)-lgammafn(phi))* p_lower;
    p_lower = p_lower + f_lower;

    if(x==1) return(p_lower);
   
    for(i=2;i<=x;i++){
      f_lower_1 = f_lower;
      p_lower_1 = p_lower;
      f_lower = (n-i+1)/(n-i+psi)*(i-1+phi)/i*f_lower_1;
      p_lower = p_lower_1 + f_lower;
    }
    return(p_lower);
  }



double _q_betabinom_exact(
  double alpha,
  double n,
  double phi,
  double psi,
  int lower_tail){
    int i;
    double p_lower, f_lower, p_lower_1, f_lower_1;
 
//   if(lower_tail) alpha=1-alpha;  
  if(alpha==1) return(n);
  if(alpha==0) return(0);
  p_lower = exp(
                + lgammafn(psi + n)
                - lgammafn(phi+psi+n)
                - lgammafn(psi)
                + lgammafn(phi+psi)
               );
  if(p_lower >= alpha) return(0);

  f_lower = n/(n-1+psi)*exp(lgammafn(1+phi)-lgammafn(phi))* p_lower;
  p_lower = p_lower + f_lower;
  if(p_lower >= alpha) return(1);
  
  for(i=2;;i++){
    f_lower_1 = f_lower;
    p_lower_1 = p_lower;
    f_lower = (n-i+1)/(n-i+psi)*(i-1+phi)/i*f_lower_1;
    p_lower = p_lower_1 + f_lower;
    if(p_lower >= alpha){
      return(i);
    }
    if(i>n) return(n);
  }
}



double _p_betabinom_hald (
  double x,
  double n,
  double phi,
  double psi){
    if(x==0)return(0);
    if(x==n)return(1);
    double h = x/n;
    double k = 1-h;
    double phipsi = phi*psi;
    double w = dbeta(h,phi,psi,0);
    double h2 = h*h;
    double h3 = h2*h;
    double k2 = k*k;
    double k3 = k2*k;
    double phi2 = phi*(phi-1);
    double psi2 = psi*(psi-1);
    
    const double one24 = 1/24;

    double B1 = 0.5*(1+phi-(phi+psi)*h)*w;
    double B2 = one24*(
                    3*(phi-1)*phi2*k3
                  - 3*(psi-1)*psi2*h3
                  + (9*phipsi+5*psi+phi-3)*psi*h2*k
                  + (9*phipsi+5*phi+psi-3)*phi*h*k2
                  + 6*psi2*h2
                  + 6*phi2*k2
                  - 2*(psi-1)*h
                  - 2*(phi-1)*k
                  - 12*phipsi*h*k
                  )*w/(h*k);
    double FB = pbeta(h,phi,psi,1,0);
    /*printf("\nFB=%.22g\tB1/n=%.22g\tB2/(n*n)=%.22g\tB2/(n*n)+B1/n=%22.g",FB,B1/n,B2/(n*n),B2/(n*n)+B1/n);*/ 

    double result = B2/(n*n) + B1/n + FB;
    return(result);    
}


/*
struct _p_bb_c {
  double alpha;
  double n;
  double phi;
  double psi;
};

double _pdiff_betabinom_continuous (double x, struct _p_bb_c *info){
  double p = _p_betabinom_continuous(x,info->n,info->phi,info->psi);
  return(p - (info->alpha));
}*/

double _d_betabinom(
  double x,
  double n,
  double phi,
  double psi
  ){
  double lresult = lgammafn(n+1)-lgammafn(x+1)-lgammafn(n-x+1)
      + lgammafn(x+phi)+lgammafn(n-x+psi)
      - lgammafn(n+phi+psi)
      - lgammafn(phi) - lgammafn(psi)
      + lgammafn(phi+psi);
  return(exp(lresult));
}


double _q_betabinom_hald (
  double p,
  double n,
  double phi,
  double psi,
  int lower,
  int maxiter,
  double eps){
    if(lower){
        if(p==0)return(0);
        if(p==1)return(n);
    } else {
        if(p==0)return(n);
        if(p==1)return(0);
    }
    if(!lower) p = 1-p;
    double result;
    double x1=n;
    double x0=0;
    double p0=0;
    double p1=1;
    int converged = 0;
    int i;


    double m;
    double s;
    double t;
    double diff;
    double denom;
    double pt;

    /*printf("\n---------------------------");*/ 

    for(i=0;i<maxiter;i++){
        m = (x1+x0)/2;
        diff = x1-x0;
        denom = p1-p0;
        s = x1-(p1-p0)*diff/denom;
        if(R_FINITE(s)&&
            fabs(x1-s)<fabs(x1-m)) t=s;
        else t=m;
        pt = _p_betabinom_hald(t,n,phi,psi);
        if((pt-p)*(p0-p)<0) {
            x1 = t;
            p1 = pt;
            }
        else {
            x0 = t;
            p0 = pt;
            }
        if(fabs(p0-p)<fabs(p1-p)){
            t = x0;  x0 = x1; x1 = t; 
            t = p0;  p0 = p1; p1 = t; 
        }
        /*printf("\ni=%d\tx1=%.7g\tx0=%.7g\tp1=%.7g\tp0=%.7g",i,x1,x0,p1,p0);
        printf("\tp=%.7g\tcrit=%.7g\teps=%.7g",p,fabs(p1-p),eps);*/ 
        if(fabs(p1-p)<eps || fabs(x1-x0)<.3 ) {
            converged = 1;
            result = x0;
            break;
        }
    }


    if(!converged) REprintf("\nNo convergence of _q_betabinom_continuous after %d iterations",i);
    
    if(lower)
      result = floor(x1);
    else
      result = ceil(x1);
    return(result);
}


double pbetabinom(
    double x,
    double n,
    double phi,
    double psi,
    int lower_tail,
    int method
    ){
        /*printf("pbetabinom x=%g, n=%g, phi=%g, psi=%g, lower_tail=%d, method=%d",x,n,phi,psi,lower_tail,method);*/ 
        double result;
        if(lower_tail){
            if(x==0) result = 0;
            else if (x==n) result =1;
            else if(method==1){
                result = _p_betabinom_exact(x,n,phi,psi);
            }
            else {
                result = _p_betabinom_hald(x,n,phi,psi);
            }
        }
        else{
            if(x==0) result = 1;
            else if (x==n) result =0;
            else if(method==1){
                result = 1-_p_betabinom_exact(x,n,phi,psi);
            }
            else {
                result = 1-_p_betabinom_hald(x,n,phi,psi);
            }
        }
        /*printf("  result=%g\n",result);*/ 
        return(result);
}


double qbetabinom(
    double p,
    double n,
    double phi,
    double psi,
    int lower_tail,
    int method,
    int maxiter,
    double eps
    ){
        /*printf("qbetabinom p=%g, n=%g, phi=%g, psi=%g, lower_tail=%d, method=%d",p,n,phi,psi,lower_tail,method);*/ 
        double result;
        if(lower_tail){
            if(method==1){
                result = _q_betabinom_exact(p,n,phi,psi,lower_tail);
            }
            else{
                result = _q_betabinom_hald(p,n,phi,psi,lower_tail,maxiter,eps);
            }
        }
        else{
            if(method==1){
                result = n-_q_betabinom_exact(p,n,phi,psi,lower_tail);
            }
            else{
                result = _q_betabinom_hald(p,n,phi,psi,lower_tail,maxiter,eps);
            }
        }
        /*printf("  result=%g\n",result);*/ 
        return(result);
}




void do_pbetabinom(
    int *length,
    double *x,
    double *n,
    double *phi,
    double *psi,
    int *lower_tail,
    int *method,
    double *p
    ){
    int i;
    for(i = 0; i < *length; i++){
        R_CheckUserInterrupt();
        p[i] = pbetabinom(x[i],n[i],phi[i],psi[i],lower_tail[0],method[i]);
    }
}

void do_qbetabinom(
    int *length,
    double *p,
    double *n,
    double *phi,
    double *psi,
    int *lower_tail,
    int *method,
    int* maxiter,
    double *eps,
    double *x
    ){
    int i;
    for(i = 0; i < *length; i++){
        R_CheckUserInterrupt();
        x[i] = qbetabinom(p[i],n[i],phi[i],psi[i],lower_tail[0],method[i],maxiter[0],eps[0]);
    }
}
