if(!is.loaded("do_pbetabinom")) dyn.load(paste("BetaBinomial", .Platform$dynlib.ext, sep=""))
# is.loaded("p_lower_betabinom")

dbetabinom <- function(x, size, phi, psi, log = FALSE){
  res <- (lgamma(size+1)-lgamma(x+1)-lgamma(size-x+1)
      + lgamma(x+phi)+lgamma(size-x+psi)
      - lgamma(size+phi+psi)
      - lgamma(phi) - lgamma(psi)
      + lgamma(phi+psi)
  )
  if(log) return(res)
  else return(exp(res))
}

pbetabinom <- function(q, size, phi, psi, lower.tail = TRUE, log.p = FALSE, method = 1){
  len.q <- length(q)
  len.size <- length(size)
  len.phi <- length(phi)
  len.psi <- length(psi)
  len.method <- length(method)
  maxlen <- max(len.q,len.size,len.phi,len.psi,len.method)
  length(q) <- maxlen
  length(size) <- maxlen
  length(phi) <- maxlen
  length(psi) <- maxlen
  length(method) <- maxlen
  q[] <- q[1:len.q]
  size[] <- size[1:len.size]
  phi[] <- phi[1:len.phi]
  psi[] <- psi[1:len.psi]
  method[] <- method[1:len.method]
  ans <- .C("do_pbetabinom",
                        as.integer(maxlen),
                        as.double(q),
                        as.double(size),
                        as.double(phi),
                        as.double(psi),
                        as.integer(lower.tail),
                        as.integer(method),
                        p = double(maxlen)
                        )$p
   if(log.p) ans <- log(ans)
   return(ans)
}

qbb.eps <- 1e-7
qbb.maxiter <- 50

qbetabinom <- function(p, size, phi, psi, lower.tail = TRUE, log.p = FALSE, method=1){
  len.p <- length(p)
  len.size <- length(size)
  len.phi <- length(phi)
  len.psi <- length(psi)
  len.method <- length(method)
  maxlen <- max(len.p,len.size,len.phi,len.psi,len.method)
  length(p) <- maxlen
  length(size) <- maxlen
  length(phi) <- maxlen
  length(psi) <- maxlen
  length(method) <- maxlen
  if(log.p) p <- exp(p)
  p[] <- p[1:len.p]
  size[] <- size[1:len.size]
  phi[] <- phi[1:len.phi]
  psi[] <- psi[1:len.psi]
  method[] <- method[1:len.method]
  
  .C("do_qbetabinom",
                        as.integer(maxlen),
                        as.double(p),
                        as.double(size),
                        as.double(phi),
                        as.double(psi),
                        as.integer(lower.tail),
                        as.integer(method),
                        as.integer(qbb.maxiter),
                        as.double(qbb.eps),
                        q = double(maxlen)
                        )$q
}


rbetabinom <- function(n, size, phi, psi){
  len.size <- length(size)
  len.phi <- length(phi)
  len.psi <- length(psi)
  length(size) <- n
  length(phi) <- n
  length(psi) <- n
  size[] <- size[1:len.size]
  phi[] <- phi[1:len.phi]
  psi[] <- psi[1:len.psi]
  p <- rbeta(n,phi,psi)
  rbinom(n,size,p)
}
